﻿Imports System.Globalization
Imports System.Windows.Data
Imports System.Windows.Media

Public Class DecimalBitToBrushConverter
    Implements IValueConverter
    Public Property ZeroBitBrush() As Brush
    Public Property OneBitBrush() As Brush


    Public Function Convert(ByVal value As Object, ByVal targetType As Type, ByVal parameter As Object, ByVal culture As CultureInfo) As Object Implements IValueConverter.Convert
        Dim number = CInt(value)
        Dim bit = Int32.Parse(TryCast(parameter, String))
        Dim digit = number \ PowerOfTen(bit \ 4) Mod 10

        Return If(((digit And (1 << (bit Mod 4))) = 0), ZeroBitBrush, OneBitBrush)
    End Function


    Public Function ConvertBack(ByVal value As Object, ByVal targetType As Type, ByVal parameter As Object, ByVal culture As CultureInfo) As Object Implements IValueConverter.ConvertBack
        Return Nothing
    End Function


    Private Function PowerOfTen(ByVal exp As Integer) As Integer
        Dim value = 1

        For i = 0 To exp - 1
            value *= 10
        Next i

        Return value
    End Function
End Class